//NetTalk
/*------------------------------------------------------------------------------*\
 =============================
   ģ: VideoWnd.cpp
 =============================
 
 [Ȩ]
 
   2000-2002  115  Ȩ
                                              
\*------------------------------------------------------------------------------*/
#include "WndX.h"
#include "WindowsX.h"
#include "AVIOMgr.h"
#include "VideoWnd.h"

#include "resource.h"

/*------------------------------------------------------------------------------*/
extern CAVIOMgr AVIO;
/*------------------------------------------------------------------------------*/
CVideoWnd::CVideoWnd()
{
	
}
/*------------------------------------------------------------------------------*/
CVideoWnd::~CVideoWnd()
{

}
/*------------------------------------------------------------------------------*/
LRESULT CVideoWnd::WndProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
			case IDC_ZOOM:
				{
					if(m_bZoomed)
					{
						
						POINT pt[5]={{0,11},{11,0},{184,0},{184,168},{0,168}};
						HRGN hrgn=CreatePolygonRgn(pt,5,ALTERNATE);
						
						SetWindowPos(m_hWnd,0,0,0,184,168,SWP_NOMOVE);
						SetWindowRgn(m_hWnd,hrgn,0);
						m_bZoomed=FALSE;
						SetRect(&m_rc,0,0,184,168);
						SetRect(&m_rcVideo,4,20,180,164);
						
						
						SetWindowPos(m_vs,0,0,0,m_rcVideo.Width(),m_rcVideo.Height(),SWP_NOMOVE);
						InvalidateRect(m_hWnd,0,TRUE);
						

						SetWindowPos(m_btnClose,0,167,5,0,0,SWP_NOSIZE);
					}
					else
					{
						POINT pt[5]={{0,11},{11,0},{360,0},{360,312},{0,312}};
						HRGN hrgn=CreatePolygonRgn(pt,5,ALTERNATE);
						SetWindowPos(m_hWnd,0,0,0,360,312,SWP_NOMOVE);													
						SetWindowRgn(m_hWnd,hrgn,FALSE);
						m_bZoomed=TRUE;
						SetRect(&m_rc,0,0,360,312);
						SetRect(&m_rcVideo,4,20,356,308);
						

						SetWindowPos(m_vs,0,0,0,m_rcVideo.Width(),m_rcVideo.Height(),SWP_NOMOVE);
						InvalidateRect(m_hWnd,0,TRUE);
						SetWindowPos(m_btnClose,0,343,5,0,0,SWP_NOSIZE);
					}
				}
				break;
			case IDC_CLOSE:
				SendMessage(m_hWnd,WM_CLOSE,0,0);
				break;
			}
		}
		break;
	case WM_INITDIALOG:
		return OnInitDialog();
		break;
	
	case WM_MOUSEMOVE:
		{
			POINT point;
			point.x=GET_X_LPARAM(lParam); 
			point.y=GET_Y_LPARAM(lParam); 
			OnMouseMove(wParam,point);
		}
		break;
	case WM_LBUTTONDOWN:
		{
			POINT point;
			point.x=GET_X_LPARAM(lParam); 
			point.y=GET_Y_LPARAM(lParam); 
			OnLButtonDown(wParam,point);	
		}
		break;
	case WM_CLOSE:
		if(m_bLocal)
			SendMessage(GetParent(m_hWnd),WM_COMMAND,IDC_VIDEO_LOCAL,0);
		else
			SendMessage(GetParent(m_hWnd),WM_COMMAND,IDC_VIDEO_OUTVIEW,0);
		break;
	
	case WM_DESTROY:
		OnDestroy();
		break;
	
	case WM_ERASEBKGND:
		return OnEraseBkgnd((HDC)wParam);
		break;
	case WM_TIMER:
		OnTimer(wParam);
		break;
	
	default:
		return CDialogX::WndProc(uMsg,wParam,lParam);
	}
	return TRUE;
}

/*------------------------------------------------------------------------------*/

BOOL CVideoWnd::OnInitDialog()
{
	
	POINT pt[5]={{0,11},{11,0},{184,0},{184,168},{0,168}};
	HRGN hrgn=CreatePolygonRgn(pt,5,ALTERNATE);
	
	
	SetWindowRgn(m_hWnd,hrgn,0);
	
	

	POINT pt2[5]={{2,11},{11,2},{119,2},{105,16,},{2,15}};
	
	m_hrgnTitle=CreatePolygonRgn(pt2,5,ALTERNATE);
	
	
	SetRect(&m_rcVideo,4,20,180,164);

	SetRect(&m_rcTitle,2,2,119,16);
	
	m_bZoomed=FALSE;
	m_bHilight=FALSE;
	
	m_btnZoom.LoadBitmaps(IDB_ZOOM1,IDB_ZOOM2,IDB_ZOOM3);
	m_btnZoom.Associate(m_hWnd,IDC_ZOOM);
	SetWindowPos(m_btnZoom,0,0,0,12,12,SWP_NOMOVE);	
	m_btnClose.LoadBitmaps(IDB_CLOSE1,IDB_CLOSE2,IDB_CLOSE3);
	m_btnClose.Associate(m_hWnd,IDC_CLOSE);
	SetWindowPos(m_btnClose,0,167,5,11,11,0);	
	m_vs.Create(m_rcVideo,m_hWnd);
	
	return FALSE;
}
/*------------------------------------------------------------------------------*/
void CVideoWnd::OnLButtonDown(UINT nFlags, POINT &point)
{
	if(PtInRegion(m_hrgnTitle,point.x,point.y))
	{
		SetCapture(m_hWnd);
		
		RECT rc;
		GetWindowRect(m_hWnd,&rc);
		MSG msg;
		while(GetMessage(&msg, NULL, 0, 0))
		{
			if (GetCapture()!=m_hWnd)
			{
				DispatchMessage(&msg);
				break;
			}
			switch(msg.message)
			{
			case WM_MOUSEMOVE:
				{
					POINT pt;
					pt.x=GET_X_LPARAM(msg.lParam);
					pt.y=GET_Y_LPARAM(msg.lParam);
					rc.left+=pt.x-point.x;
					rc.top+=pt.y-point.y;
					SetWindowPos(m_hWnd,0,rc.left,
						rc.top,0,0,SWP_NOSIZE);
				}
				break;
			case WM_LBUTTONUP:
				
				goto EXITLOOP1;					
				
			default:
				DispatchMessage(&msg);
				break;
				
			}
		}
EXITLOOP1:
		ReleaseCapture();
	}

}

/*------------------------------------------------------------------------------*/

BOOL CVideoWnd::OnEraseBkgnd(HDC hdc)
{
	HDC hMemDC;
	hMemDC=CreateCompatibleDC(hdc);
	HBITMAP hface;
	if(m_bZoomed)
	{
		hface=LoadBitmap(hInstX,(LPCTSTR)IDB_VIDEO2);
	}
	else
	{
		hface=LoadBitmap(hInstX,(LPCTSTR)IDB_VIDEO1);
	}
	HBITMAP hob=(HBITMAP)SelectObject(hMemDC,hface);

	if(m_bHilight)
	{
		DrawTransBmpX(hMemDC,m_rcTitle,m_hbmpT2,0,0,0);
	}
	else
		DrawTransBmpX(hMemDC,m_rcTitle,m_hbmpT1,0,0,0);

	BitBlt(hdc,0,0,400,400,hMemDC,0,0,SRCCOPY);
	SetTextColor(hdc,0x00ffffff);
	SetBkMode(hdc,TRANSPARENT);
	HFONT hof=(HFONT)SelectObject(hdc,(HFONT)GetStockObject(DEFAULT_GUI_FONT));
	if(strlen(m_szErr)>0)
		DrawText(hdc,m_szErr,strlen(m_szErr),&m_rcVideo,DT_VCENTER|DT_CENTER|DT_SINGLELINE);
	SelectObject(hdc,hof);
	SelectObject(hMemDC,hob);
	DeleteObject(hface);
		
	DeleteDC(hMemDC);
	return TRUE;

}

/*------------------------------------------------------------------------------*/
void CVideoWnd::SetErrTxt(char *err)
{
	if(err)
	{
		strcpy(m_szErr,err);
		SetTimer(m_hWnd,2,5000,0);
	}
	else
		m_szErr[0]=0;
	InvalidateRect(m_hWnd,0,TRUE);
		
	

}
/*------------------------------------------------------------------------------*/
void CVideoWnd::OnDestroy()
{
	if(m_hrgnTitle)
		DeleteObject(m_hrgnTitle);
	if(m_hbmpT1)
		DeleteObject(m_hbmpT1);
	if(m_hbmpT2)
		DeleteObject(m_hbmpT2);
}
/*------------------------------------------------------------------------------*/
void CVideoWnd::OnMouseMove(UINT nFlags, POINT point)
{
	
	if(PtInRegion(m_hrgnTitle,point.x,point.y))
	{
		if(!m_bHilight)
		{
			m_bHilight=TRUE;
			HDC hdc=GetDC(m_hWnd);
			
			DrawTransBmpX(hdc,m_rcTitle,m_hbmpT2,0,0,0);
			
			ReleaseDC(m_hWnd,hdc);
			SetTimer(m_hWnd,1,50,0);
		}
	}
}
/*------------------------------------------------------------------------------*/
void CVideoWnd::OnTimer(UINT nIDEvent)
{
	if(nIDEvent==1)
	{
		DWORD dw=GetMessagePos();
		POINT pt;
		pt.x=GET_X_LPARAM(dw);
		pt.y=GET_Y_LPARAM(dw);
		ScreenToClient(m_hWnd,&pt);
		if(m_bHilight)
		{
			
			
			if(!PtInRegion(m_hrgnTitle,pt.x,pt.y))
			{
				RECT rc;
				SetRect(&rc,2,2,119,16);
				m_bHilight=FALSE;
				HDC hdc=GetDC(m_hWnd);
				
				DrawTransBmpX(hdc,rc,m_hbmpT1,0,0,0);
				ReleaseDC(m_hWnd,hdc);
				KillTimer(m_hWnd,1);
			}
			
			
		}
	}
	else
	if(nIDEvent==2)
	{
		SetErrTxt(0);
		KillTimer(m_hWnd,2);
	}

}
/*------------------------------------------------------------------------------*/
BOOL CVideoWnd::Create(UINT ID,HWND hParent, BOOL bLocal)
{
	m_bLocal=bLocal;
	if(bLocal)
	{
		m_hbmpT1=LoadBitmap(hInstX,LPCTSTR(IDB_VIDEOTITLE1));
		m_hbmpT2=LoadBitmap(hInstX,LPCTSTR(IDB_VIDEOTITLE2));
	}
	else
	{
		m_hbmpT1=LoadBitmap(hInstX,LPCTSTR(IDB_VIDEOTITLE3));
		m_hbmpT2=LoadBitmap(hInstX,LPCTSTR(IDB_VIDEOTITLE4));
	}
	
	return CDialogX::Create((LPCTSTR)ID,hParent);
}
/*------------------------------------------------------------------------------*/
CVideoShow::CVideoShow()
{
}

/*------------------------------------------------------------------------------*/
CVideoShow::~CVideoShow()
{

}

/*------------------------------------------------------------------------------*/

LRESULT CVideoShow::WndProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	
	case WM_CREATE:
		{
			CRectX rc;
			GetClientRect(m_hWnd,&rc);
			HDC hdc=GetDC(m_hWnd);
			m_hBmp=CreateCompatibleBitmap(hdc,rc.Width(),rc.Height());
			HBITMAP hob=(HBITMAP)SelectObject(hdc,m_hBmp);
			FillSolidRectX(hdc,rc,0);
			SelectObject(hdc,hob);
			ReleaseDC(m_hWnd,hdc);
		}
		break;
	case WM_DESTROY:
		{
			DeleteObject(m_hBmp);
		}
		break;
	case WM_ERASEBKGND:
		{
			RECT rc;
			GetClientRect(m_hWnd,&rc);
			HDC hMemDC=CreateCompatibleDC((HDC)wParam);
			HBITMAP hob=(HBITMAP)SelectObject(hMemDC,m_hBmp);
			BitBlt((HDC)wParam,0,0,rc.right,rc.bottom,hMemDC,0,0,SRCCOPY);
			SelectObject(hMemDC,hob);
			DeleteDC(hMemDC);
		}
		return TRUE;
	case IOM_VIDEO:
		OnVideoData((BOOL)wParam,(CAVIOMgr*)lParam);
		break;
	case WM_SIZE:
		{
			RECT rc;
			GetClientRect(m_hWnd,&rc);
			DeleteObject(m_hBmp);
			HDC hdc=GetDC(m_hWnd);
			m_hBmp=CreateCompatibleBitmap(hdc,rc.right,rc.bottom);
			HBITMAP hob=(HBITMAP)SelectObject(hdc,m_hBmp);
					
			FillSolidRectX(hdc,rc,0);
			SelectObject(hdc,hob);
			ReleaseDC(m_hWnd,hdc);
		}
		break;
	
	}
	return CWndX::WndProc(uMsg,wParam,lParam);
}
/*------------------------------------------------------------------------------*/
BOOL CVideoShow::Create(RECT &rc, HWND hParent)
{
	return CWndX::Create(0,0,0,WS_CHILD,rc,hParent,0);
}
/*------------------------------------------------------------------------------*/
//õƵݣ
void CVideoShow::OnVideoData(BOOL flag, CAVIOMgr *pMgr)
{
	
	HDC hdc=GetDC(m_hWnd);
	HDC hMemDC=CreateCompatibleDC(hdc);
	HBITMAP hob=(HBITMAP)SelectObject(hMemDC,m_hBmp);
	RECT rc;
	GetClientRect(m_hWnd,&rc);
	if(hob)
	{			
		UINT len;
		char* p;
		if(flag)
			p=pMgr->GetRemoteVideo(len);//!!
		else
			p=pMgr->GetLocalVideo(len);
		BITMAPINFOHEADER* pbih=&pMgr->GetBitampInfo()->bmiHeader;
		
		HDRAWDIB h=DrawDibOpen();
		DrawDibDraw(h,hMemDC,0,0,rc.right,rc.bottom,pbih,p,0,0,pbih->biWidth,pbih->biHeight,DDF_NOTKEYFRAME);
		DrawDibClose(h);
				
		BitBlt(hdc,0,0,rc.right,rc.bottom,hMemDC,0,0,SRCCOPY);
		SelectObject(hMemDC,hob);
	}
	DeleteDC(hMemDC);
	ReleaseDC(m_hWnd,hdc);
	
	if(!IsWindowVisible(m_hWnd))
		ShowWindow(m_hWnd,SW_SHOW);
}



