//NetTalk
/*------------------------------------------------------------------------------*\
 =============================
   ģ: GDIX.cpp
 =============================
 
 [Ȩ]
 
   2000-2002  115  Ȩ
                                              
\*------------------------------------------------------------------------------*/
#include <Windows.h>

#include "GDIX.h"

/*------------------------------------------------------------------------------*/
//ʵ
CRectX::operator RECT&() const
{		
	return (RECT&)left;
}
/*------------------------------------------------------------------------------*/
CRectX::CRectX(int iLeft,int iTop,int iRight,int iBottom)
{
	left=iLeft;
	top=iTop;
	right=iRight;
	bottom=iBottom;
}
/*------------------------------------------------------------------------------*/
CRectX::CRectX()
{
	left=0;
	top=0;
	right=0;
	bottom=0;
}
/*------------------------------------------------------------------------------*/
CRectX::CRectX(const RECT &rc)
{
	left=rc.left;
	top=rc.top;
	right=rc.right;
	bottom=rc.bottom;
}
/*------------------------------------------------------------------------------*/
CRectX::CRectX(POINT pt,SIZE sz)
{
	left=pt.x;
	top=pt.y;
	right=pt.x+sz.cx;
	bottom=pt.y+sz.cy;
}
/*------------------------------------------------------------------------------*/
CRectX::CRectX(POINT lt,POINT rb)
{
	left=lt.x;
	top=lt.y;
	right=rb.x;
	bottom=rb.y;
}
/*------------------------------------------------------------------------------*/
CRectX::~CRectX()
{
}
/*------------------------------------------------------------------------------*/
int CRectX::Width() const
{
	return right-left;
}
/*------------------------------------------------------------------------------*/
int CRectX::Height() const
{
	return bottom-top;
}
/*------------------------------------------------------------------------------*/
SIZE CRectX::Size() const
{
	SIZE sz;
	sz.cx=right-left;
	sz.cy=bottom-top;
	return sz;
}
/*------------------------------------------------------------------------------*/
void CRectX::operator =( const RECT& rc )
{
	left=rc.left;
	top=rc.top;
	right=rc.right;
	bottom=rc.bottom;
}
/*------------------------------------------------------------------------------*/
//pointʵ
const POINT& CRectX::TopLeft() const
{
	return (POINT&)left;
}
/*------------------------------------------------------------------------------*/
const POINT& CRectX::BottomRight() const
{
	return (POINT&)right;
}
/*------------------------------------------------------------------------------*/
RECT* operator &(CRectX& rc )
{
	return (RECT*)&rc.left;
}
/*------------------------------------------------------------------------------*/
POINT CRectX::CenterPoint()
{
	POINT pt;
	pt.x=left+(right-left)/2;
	pt.y=top+(bottom-top)/2;
	return pt;
}
/*------------------------------------------------------------------------------*/
void CRectX::Normalize()
{
	if(left>right)
	{
		LONG temp=left;
		left=right;
		right=temp;
	}
	if(top>bottom)
	{
		LONG temp=top;
		top=bottom;
		bottom=temp;
	}

}
/*------------------------------------------------------------------------------*/
//һ龭õGDI


//3Dľ
BOOL Draw3dRectX(HDC hdc, RECT &rect, COLORREF clrTopLeft, COLORREF clrBottomRight,int iPenWidth)
{
	BOOL bRet=FALSE;
	HPEN hpen,hOld;
	
	hpen=CreatePen(PS_SOLID,iPenWidth,clrTopLeft);
	if(hpen)
	{
		hOld=(HPEN)SelectObject(hdc,hpen);
		MoveToEx(hdc,rect.left,rect.bottom-1,0);
		LineTo(hdc,rect.left,rect.top);
		MoveToEx(hdc,rect.left,rect.top,0);
		LineTo(hdc,rect.right-1,rect.top);
		SelectObject(hdc,hOld);
		DeleteObject(hpen);
		
		hpen=CreatePen(PS_SOLID,iPenWidth,clrBottomRight);
		if(hpen)
		{
			hOld=(HPEN)SelectObject(hdc,hpen);
			MoveToEx(hdc,rect.right-1,rect.top,0);
			LineTo(hdc,rect.right-1,rect.bottom);
			MoveToEx(hdc,rect.right-1,rect.bottom-1,0);
			LineTo(hdc,rect.left-1,rect.bottom-1);
			SelectObject(hdc,hOld);
			DeleteObject(hpen);
			bRet=TRUE;
		}
		
	}
	return bRet;


}
/*------------------------------------------------------------------------------*/
//ΣֱӸɫ
void DrawRectX(HDC hDC,const RECT& rect,COLORREF cr)
{
	HBRUSH hb;
	hb=CreateSolidBrush(cr);
	FrameRect(hDC,&rect,hb);
	DeleteObject(hb);
}
/*------------------------------------------------------------------------------*/
//ΣֱӸɫ
void FillSolidRectX( HDC hDC, const RECT& rect, COLORREF cr )
{
	HBRUSH hb;
	hb=CreateSolidBrush(cr);
	FillRect(hDC,&rect,hb);
	DeleteObject(hb);
	
}
/*------------------------------------------------------------------------------*/
//͸λͼ
void DrawTransBmpX(HDC hDC,RECT& rect,HBITMAP hBmp,int x,int y,COLORREF crMask)
{
	HDC hdcBmp,hdcTrans;
	HBITMAP hBmpTrans;

	hdcBmp=CreateCompatibleDC(hDC);
	hdcTrans=CreateCompatibleDC(hDC);

    int nWidth,nHeight;
	nWidth=rect.right-rect.left;
	nHeight=rect.bottom-rect.top;

	COLORREF crOldBack = SetBkColor(hDC,0x00ffffff);
	COLORREF crOldText = SetTextColor(hDC,0);
	
	HBITMAP hOldBmp=(HBITMAP)SelectObject(hdcBmp,hBmp);
	
	hBmpTrans=CreateBitmap(rect.right-rect.left,rect.bottom-rect.top,1, 1, NULL);


	HBITMAP hOldBmpTrans =(HBITMAP)SelectObject(hdcTrans,hBmpTrans);
		
	SetBkColor(hdcBmp,crMask);
	BitBlt(hdcTrans,0,0,nWidth,nHeight,hdcBmp,0,0,SRCCOPY);
	
	
	
	BitBlt(hDC,rect.left,rect.top, nWidth, nHeight, hdcBmp, x, y, SRCINVERT);
	BitBlt(hDC,rect.left,rect.top, nWidth, nHeight, hdcTrans, x, y, SRCAND);
	BitBlt(hDC,rect.left,rect.top, nWidth, nHeight, hdcBmp, x, y, SRCINVERT);

	
	SelectObject(hdcBmp,hOldBmp);
	SelectObject(hdcTrans,hOldBmpTrans);
	SetBkColor(hDC,crOldBack);
	SetTextColor(hDC,crOldText);
	DeleteObject(hBmpTrans);
	DeleteDC(hdcTrans);
	DeleteDC(hdcBmp);

}

/*------------------------------------------------------------------------------*/
//Bltʽдı
void TxtBlt(HDC hdc,char* txt,CRectX& rc,COLORREF crTxt,COLORREF crBg,UINT uFormat,HFONT hf,BOOL bTransparent)
{
	HDC hMemDC;
	CRectX rcNew;
	rcNew.left=0;
	rcNew.top=0;
	rcNew.right=rc.Width();
	rcNew.bottom=rc.Height();

	hMemDC=CreateCompatibleDC(hdc);
	HBITMAP hb=CreateCompatibleBitmap(hdc,rc.Width(),rc.Height());
	

	HBITMAP hob=(HBITMAP)SelectObject(hMemDC,hb);
	HFONT hof=(HFONT)SelectObject(hMemDC,hf);
	SetTextColor(hMemDC,crTxt);
	SetBkMode(hMemDC,TRANSPARENT);

	FillSolidRectX(hMemDC,rcNew,crBg);
	if(txt)
		DrawText(hMemDC,txt,strlen(txt),&rcNew,uFormat);

	
	if(bTransparent)
	{
		SelectObject(hMemDC,hob);
		DrawTransBmpX(hdc,rc,hb,0,0,crBg);
	}
	else
	{
		BitBlt(hdc,rc.left,rc.top,rc.Width(),rc.Height(),hMemDC,0,0,SRCCOPY);
		SelectObject(hMemDC,hob);
		
	}
	SelectObject(hMemDC,hof);
		
	DeleteObject(hb);
	DeleteDC(hMemDC);
}

